; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F72
; Clock frequency: 12.0 MHz
;
;       The address of 'digit' (byte) (global) is 0x2C
LIST P=16F72
#INCLUDE<P16F72.INC>
	digit EQU 0x2C
;       The address of 'h' (byte) (global) is 0x2D
	h EQU 0x2D
;       The address of 'mask4' (byte) (global) is 0x2E
	mask4 EQU 0x2E
;       The address of 'k' (byte) (global) is 0x2F
	k EQU 0x2F
;       The address of 'mask' (byte) (global) is 0x30
	mask EQU 0x30
;       The address of 'ampm' (bit) (global) is 0x31,0
;       The address of 'mask3' (byte) (global) is 0x32
	mask3 EQU 0x32
;       The address of 'i' (byte) (global) is 0x33
	i EQU 0x33
;       The address of 'digit4' (byte) (global) is 0x34
	digit4 EQU 0x34
;       The address of 'mask1' (byte) (global) is 0x35
	mask1 EQU 0x35
;       The address of 'mask2' (byte) (global) is 0x36
	mask2 EQU 0x36
;       The address of 'j' (byte) (global) is 0x37
	j EQU 0x37
;       The address of 'digit1' (byte) (global) is 0x38
	digit1 EQU 0x38
;       The address of 'digit2' (byte) (global) is 0x39
	digit2 EQU 0x39
;       The address of 'digit3' (byte) (global) is 0x3A
	digit3 EQU 0x3A
;       The address of 'tt' (byte) (global) is 0x3B
	tt EQU 0x3B
;       The address of 'phase' (bit) (global) is 0x31,1
;       The address of 'tem' (byte) (global) is 0x3C
	tem EQU 0x3C
;       The address of 'h_al' (byte) (global) is 0x3D
	h_al EQU 0x3D
;       The address of 'k_al' (byte) (global) is 0x3E
	k_al EQU 0x3E
;       The address of 'al_ampm' (bit) (global) is 0x31,2
;       The address of 'd1enable' (bit) (global) is 0x7,4
;       The address of 'd2enable' (bit) (global) is 0x7,5
;       The address of 'ad_action' (bit) (global) is 0x1F,2
;       The address of 'd3enable' (bit) (global) is 0x7,6
;       The address of 'd4enable' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	W_TEMP EQU 0x7F
	STATUS_TEMP EQU 0x7E
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0016
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; LookUp Table: (0x18, 0x7b, 0x2c, 0x29, 0x4b, 0x89, 0x88, 0x3b, 0x08, 0x09)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x18
	RETLW 0x7B
	RETLW 0x2C
	RETLW 0x29
	RETLW 0x4B
	RETLW 0x89
	RETLW 0x88
	RETLW 0x3B
	RETLW 0x08
	RETLW 0x09
; LookUp Table: (0x18, 0x7b, 0x34, 0x31, 0x53, 0x91, 0x90, 0x3b, 0x10, 0x11)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x18
	RETLW 0x7B
	RETLW 0x34
	RETLW 0x31
	RETLW 0x53
	RETLW 0x91
	RETLW 0x90
	RETLW 0x3B
	RETLW 0x10
	RETLW 0x11
; Begin of program
L0015:
; 1: Dim digit As Byte  'input variable for GETMASK subroutine
; 2: Dim digit1 As Byte  'current high digit
; 3: Dim digit2 As Byte  'current low digit
; 4: Dim mask As Byte  'output variable from GETMASK subroutine
; 5: Dim mask1 As Byte  'current high digit mask
; 6: Dim mask2 As Byte  'current low digit mask
; 7: Dim tem As Byte  'temperture
; 8: Dim i As Byte
; 9: Dim k As Byte
; 10: Dim j As Byte
; 11: Dim h As Byte
; 12: Dim mask3 As Byte
; 13: Dim mask4 As Byte
; 14: Dim digit3 As Byte
; 15: Dim tt As Byte
; 16: Dim digit4 As Byte
; 17: Dim h_al As Byte
; 18: Dim k_al As Byte
; 19: Dim ampm As Bit
; 20: Dim phase As Bit
; 21: Dim al_ampm As Bit
; 22: Symbol d1enable = PORTC.4  'enable line for higher 7-segment display
; 23: Symbol d2enable = PORTC.5
; 24: Symbol ad_action = ADCON0.GO_DONE
; 25: 'enable line for lower 7-segment display
; 26: Symbol d3enable = PORTC.6
; 27: Symbol d4enable = PORTC.7
; 28: TRISB = %00000000  'set PORTB pins as outputs
	BSF STATUS,RP0
	CLRF 0x06
; 29: TRISC.0 = 1  'set RC0 pin as input
	BSF 0x07,0
; 30: TRISC.1 = 1  'set RC1 pin as input
	BSF 0x07,1
; 31: TRISC.2 = 0  'set RC2 pin as output
	BCF 0x07,2
; 32: TRISC.3 = 1  'set RC3 pin as input
	BSF 0x07,3
; 33: TRISC.4 = 0
	BCF 0x07,4
; 34: TRISC.5 = 0
	BCF 0x07,5
; 35: TRISC.6 = 0
	BCF 0x07,6
; 36: TRISC.7 = 0
	BCF 0x07,7
	BCF STATUS,RP0
; 37: d1enable = True
	BSF 0x07,4
; 38: d2enable = True
	BSF 0x07,5
; 39: d3enable = True
	BSF 0x07,6
; 40: d4enable = True
	BSF 0x07,7
; 41: 
; 42: TRISA = %111111  'set PORTA pins as inputs
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 43: ADCON0 = 0xc0  'set A/D conversion clock to internal source
	MOVLW 0xC0
	MOVWF 0x1F
; 44: ADCON1 = 1  'set PORTA pins as analog inputs
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 45: High ADCON0.ADON  'turn on A/D converter module
	BSF 0x1F,0
; 46: 
; 47: 
; 48: 
; 49: PORTB = ADRES
	MOVF 0x1E,W
	MOVWF 0x06
; 50: 
; 51: mask1 = 0
	CLRF 0x35
; 52: mask2 = 0
	CLRF 0x36
; 53: phase = 0
	BCF 0x31,1
; 54: INTCON.T0IE = 1  'enable Timer0 interrupts
	BSF 0x0B,5
; 55: INTCON.GIE = 1  'enable all un-masked interrupts
	BSF 0x0B,7
; 56: OPTION_REG = 07
	MOVLW 0x07
	BSF STATUS,RP0
	MOVWF 0x01
; 57: 
; 58: OPTION_REG.T0CS = 0
	BCF 0x01,5
	BCF STATUS,RP0
; 59: 'set Timer0 clock source to internal instruction cycle clock
; 60: k = 31
	MOVLW 0x1F
	MOVWF 0x2F
; 61: i = 28
	MOVLW 0x1C
	MOVWF 0x33
; 62: j = 0
	CLRF 0x37
; 63: h = 11
	MOVLW 0x0B
	MOVWF 0x2D
; 64: k_al = 30
	MOVLW 0x1E
	MOVWF 0x3E
; 65: h_al = 6
	MOVLW 0x06
	MOVWF 0x3D
; 66: PORTC.7 = 1
	BSF 0x07,7
; 67: ampm = 1  'day is zero night is 1
	BSF 0x31,0
; 68: phase = 1
	BSF 0x31,1
; 69: loop:
L0001:
; 70: 
; 71: If i > 30 And i < 35 Then
	MOVF 0x33,W
	SUBLW 0x1E
	BTFSC STATUS,C
	GOTO L0017
	MOVLW 0x23
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0017
; 72: Gosub tempshow
	CALL L0013
; 73: Endif
L0017:
; 74: If PORTC.0 = 0 Then Gosub clockset
	BTFSC 0x07,0
	GOTO L0018
	CALL L0007
L0018:
; 75: If PORTC.1 = 0 Then Gosub clockset
	BTFSC 0x07,1
	GOTO L0019
	CALL L0007
L0019:
; 76: 'i =sec
; 77: 'k is minutes
; 78: 'h is hours
; 79: 
; 80: If k > 59 Then
	MOVF 0x2F,W
	SUBLW 0x3B
	BTFSC STATUS,C
	GOTO L0020
; 81: k = 0
	CLRF 0x2F
; 82: h = h + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 83: If h > 12 Then
	MOVF 0x2D,W
	SUBLW 0x0C
	BTFSC STATUS,C
	GOTO L0021
; 84: h = 1
	MOVLW 0x01
	MOVWF 0x2D
; 85: Toggle ampm
	MOVLW 0x01
	XORWF 0x31,F
; 86: Endif
L0021:
; 87: Endif
L0020:
; 88: 
; 89: 	digit2 = k / 10  'get time minutes tens
	MOVF 0x2F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x39
; 90: 		digit1 = k Mod 10  'get time minutes units
	MOVF 0x2F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x38
; 91: 	digit = digit1
	MOVF 0x38,W
	MOVWF 0x2C
; 92: 	Gosub getmask1  'get Segment code for units minutes
	CALL L0004
; 93: 	mask1 = mask
	MOVF 0x30,W
	MOVWF 0x35
; 94: 	digit = digit2
	MOVF 0x39,W
	MOVWF 0x2C
; 95: 		Gosub getmask  'get code for tens minutes
	CALL L0003
; 96: 	mask2 = mask
	MOVF 0x30,W
	MOVWF 0x36
; 97: 	Gosub show1  'display the units minutes
	CALL L0005
; 98: 	Gosub show2  'display the tens minutes
	CALL L0006
; 99: 	
; 100: digit4 = h / 10
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x34
; 101: digit3 = h Mod 10
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x3A
; 102: digit = digit3
	MOVF 0x3A,W
	MOVWF 0x2C
; 103: 	Gosub getmask  'get segment code mask for hours units digit
	CALL L0003
; 104: 	mask3 = mask
	MOVF 0x30,W
	MOVWF 0x32
; 105: 	If phase = 1 Then mask3 = mask3 And 0xf7
	BTFSS 0x31,1
	GOTO L0022
	MOVF 0x32,W
	MOVWF R0L
	MOVLW 0xF7
	ANDWF R0L,W
	MOVWF 0x32
L0022:
; 106: 	'this is for blinking the seconds decimal point on this digit 3
; 107: 	Gosub show3
	CALL L0010
; 108: digit = digit4
	MOVF 0x34,W
	MOVWF 0x2C
; 109: 	Gosub getmask  'get segment code mask for hours tens  digit
	CALL L0003
; 110: 	mask4 = mask
	MOVF 0x30,W
	MOVWF 0x2E
; 111: If ampm = 0 Then mask4 = mask4 - 1
	BTFSC 0x31,0
	GOTO L0023
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
L0023:
; 112: 	If ampm = 1 Then mask4 = mask4 - 32
	BTFSS 0x31,0
	GOTO L0024
	MOVLW 0x20
	SUBWF 0x2E,W
	MOVWF 0x2E
L0024:
; 113: 
; 114: If digit4 = 0 Then
	MOVF 0x34,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0025
; 115: 
; 116: If ampm = 0 Then mask4 = 0xfe
	BTFSC 0x31,0
	GOTO L0026
	MOVLW 0xFE
	MOVWF 0x2E
L0026:
; 117: If ampm = 1 Then mask4 = 0xdf
	BTFSS 0x31,0
	GOTO L0027
	MOVLW 0xDF
	MOVWF 0x2E
L0027:
; 118: Endif
L0025:
; 119: 	'If digit4 = 0 Then Goto k4  'if hours is <10 then darken digit 4
; 120: Gosub show4
	CALL L0011
; 121: 
; 122: k4: If h = h_al And k = k_al Then
L0002:
	MOVF 0x2D,W
	SUBWF 0x3D,W
	BTFSS STATUS,Z
	GOTO L0028
	MOVF 0x2F,W
	SUBWF 0x3E,W
	BTFSS STATUS,Z
	GOTO L0028
; 123: If ampm = al_ampm Then
	CLRW
	BTFSC 0x31,0
	ADDLW 0x01
	BTFSC 0x31,2
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0029
; 124: 'if current hours and minutes are equal to alarm set values
; 125: PORTC.2 = 1
	BSF 0x07,2
; 126: Endif
L0029:
; 127: Else
	GOTO L0030
L0028:
; 128: PORTC.2 = 0
	BCF 0x07,2
; 129: 
; 130: Endif
L0030:
; 131: 'PORTC.1 = ampm
; 132: Goto loop
	GOTO L0001
; 133: End
L0031:	GOTO L0031
; 134: 
; 135: On Interrupt  'Timer0 interrupt routine
L0016:
; 136: 
; 137: 
; 138: j = j + 1  'this j counts number of interrupts
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 139: If j > 76 Then  '76 accounts for 1 second time.
	MOVF 0x37,W
	SUBLW 0x4C
	BTFSC STATUS,C
	GOTO L0032
; 140: j = 1  'count j from 1 to 76 to complete a second
	MOVLW 0x01
	MOVWF 0x37
; 141: 
; 142: 
; 143: i = i + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 144: 'i is seconds
; 145: If i > 59 Then
	MOVF 0x33,W
	SUBLW 0x3B
	BTFSC STATUS,C
	GOTO L0033
; 146: i = 0
	CLRF 0x33
; 147: 
; 148: k = k + 1  'k counts minutes.
	MOVF 0x2F,W
	ADDLW 0x01
	MOVWF 0x2F
; 149: If k > 59 Then
	MOVF 0x2F,W
	SUBLW 0x3B
	BTFSC STATUS,C
	GOTO L0034
; 150: k = 0
	CLRF 0x2F
; 151: h = h + 1  'h counts hours
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 152: If h > 12 Then
	MOVF 0x2D,W
	SUBLW 0x0C
	BTFSC STATUS,C
	GOTO L0035
; 153: h = 1
	MOVLW 0x01
	MOVWF 0x2D
; 154: Toggle ampm
	MOVLW 0x01
	XORWF 0x31,F
; 155: Endif
L0035:
; 156: Endif
L0034:
; 157: Endif
L0033:
; 158: 
; 159: If PORTC.3 = 0 Then  'this pin 14 if made low by switch S2
	BTFSC 0x07,3
	GOTO L0036
; 160: h_al = h  'then make the alrm time equal to current displayed time
	MOVF 0x2D,W
	MOVWF 0x3D
; 161: k_al = k
	MOVF 0x2F,W
	MOVWF 0x3E
; 162: al_ampm = ampm
	BTFSC 0x31,0
	BSF 0x31,2
	BTFSS 0x31,0
	BCF 0x31,2
; 163: Endif
L0036:
; 164: Toggle phase  'for seconds blinking on digit 3 LED
	MOVLW 0x02
	XORWF 0x31,F
; 165: Endif
L0032:
; 166: 
; 167: 
; 168: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF 0x0B,2
; 169: Resume
	RETURN
; 170: 
; 171: 
; 172: getmask:  'get appropriate 7-segment mask for input digit
L0003:
; 173: 	'mask = LookUp(0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x07, 0x7f, 0x6f), digit
; 174: 	'the above mask values are for direct sequential connection from port b to a,b,c,d,e,f,g,DP
; 175: 
; 176: 
; 177: 	'mask = LookUp(0x88, 0xee, 0x94, 0xc4, 0xe2, 0xc1, 0x81, 0xec, 0x80, 0xe0), digit
; 178: 	'mask = LookUp(0x88, 0xee, 0x94, 0xc4, 0xe2, 0xc1, 0x81, 0xec, 0x80, 0xe0), digit
; 179: mask = LookUp(0x18, 0x7b, 0x2c, 0x29, 0x4b, 0x89, 0x88, 0x3b, 0x08, 0x09), digit
	MOVF 0x2C,W
	MOVWF R0L
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0037
	CALL _lookup_lab_0001
	MOVWF 0x30
L0037:
; 180: 	'the above mask values are for a modified connection to facilitate pcb routing from Port B pins to LEDs
; 181: Return
	RETURN
; 182: getmask1:  'get appropriate 7-segment mask for input digit
L0004:
; 183: 	
; 184: mask = LookUp(0x18, 0x7b, 0x34, 0x31, 0x53, 0x91, 0x90, 0x3b, 0x10, 0x11), digit
	MOVF 0x2C,W
	MOVWF R0L
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0038
	CALL _lookup_lab_0002
	MOVWF 0x30
L0038:
; 185: 	'the above mask values are for a modified connection to facilitate pcb routing from Port B pins to LEDs
; 186: Return
	RETURN
; 187: show1:  'show the digit on its display no.1 (rightmost display LED)
L0005:
; 188: 	d1enable = 1  'False
	BSF 0x07,4
; 189: 	PORTB = mask1
	MOVF 0x35,W
	MOVWF 0x06
; 190: 	d1enable = 0  'True
	BCF 0x07,4
; 191: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 192: 	d1enable = 1  'False
	BSF 0x07,4
; 193: Return
	RETURN
; 194: 
; 195: show2:  'show low digit on its display no.2 from right
L0006:
; 196: 	d2enable = 1  'False
	BSF 0x07,5
; 197: 	PORTB = mask2
	MOVF 0x36,W
	MOVWF 0x06
; 198: 	d2enable = 0  'True
	BCF 0x07,5
; 199: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 200: 	d2enable = 1  'False
	BSF 0x07,5
; 201: 	Return
	RETURN
; 202: clockset:
L0007:
; 203: INTCON.GIE = 0  'disable all un-masked interrupts
	BCF 0x0B,7
; 204: 
; 205: kk:
L0008:
; 206: If PORTC.1 = 0 Then WaitMs 1
	BTFSC 0x07,1
	GOTO L0039
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
L0039:
; 207: If PORTC.0 = 0 Then WaitMs 10
	BTFSC 0x07,0
	GOTO L0040
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
L0040:
; 208: k = k + 1
	MOVF 0x2F,W
	ADDLW 0x01
	MOVWF 0x2F
; 209: If k >= 60 Then
	MOVLW 0x3C
	SUBWF 0x2F,W
	BTFSS STATUS,C
	GOTO L0041
; 210: k = 0
	CLRF 0x2F
; 211: h = h + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 212: If h > 12 Then
	MOVF 0x2D,W
	SUBLW 0x0C
	BTFSC STATUS,C
	GOTO L0042
; 213: h = 1
	MOVLW 0x01
	MOVWF 0x2D
; 214: Toggle ampm
	MOVLW 0x01
	XORWF 0x31,F
; 215: Endif
L0042:
; 216: Endif
L0041:
; 217: digit2 = k / 10  'get current high minutes
	MOVF 0x2F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x39
; 218: 	digit1 = k Mod 10  'get current low minutes
	MOVF 0x2F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x38
; 219: 	
; 220: 	digit = digit1
	MOVF 0x38,W
	MOVWF 0x2C
; 221: 	Gosub getmask1  'get segent code for minutes tens
	CALL L0004
; 222: 	mask1 = mask
	MOVF 0x30,W
	MOVWF 0x35
; 223: 	digit = digit2
	MOVF 0x39,W
	MOVWF 0x2C
; 224: 		Gosub getmask  'get seg. code for minutes ones
	CALL L0003
; 225: 	mask2 = mask
	MOVF 0x30,W
	MOVWF 0x36
; 226: 	Gosub show1  'display Ist digit
	CALL L0005
; 227: 	Gosub show2  'display 2nd digit
	CALL L0006
; 228: 	WaitMs 1  'delay interval
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 229: digit4 = h / 10
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x34
; 230: digit3 = h Mod 10
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x3A
; 231: digit = digit3
	MOVF 0x3A,W
	MOVWF 0x2C
; 232: 	Gosub getmask  'getseg. code
	CALL L0003
; 233: 	mask3 = mask
	MOVF 0x30,W
	MOVWF 0x32
; 234: digit = digit4
	MOVF 0x34,W
	MOVWF 0x2C
; 235: 	Gosub getmask  'getseg. code for 4th digit
	CALL L0003
; 236: 	mask4 = mask
	MOVF 0x30,W
	MOVWF 0x2E
; 237: 	If ampm = 0 Then mask4 = mask4 - 1
	BTFSC 0x31,0
	GOTO L0043
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
L0043:
; 238: 	If ampm = 1 Then mask4 = mask4 - 32
	BTFSS 0x31,0
	GOTO L0044
	MOVLW 0x20
	SUBWF 0x2E,W
	MOVWF 0x2E
L0044:
; 239: 	Gosub show3
	CALL L0010
; 240: If digit4 = 0 Then
	MOVF 0x34,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0045
; 241: 
; 242: If ampm = 0 Then mask4 = 0xfe
	BTFSC 0x31,0
	GOTO L0046
	MOVLW 0xFE
	MOVWF 0x2E
L0046:
; 243: If ampm = 1 Then mask4 = 0xdf
	BTFSS 0x31,0
	GOTO L0047
	MOVLW 0xDF
	MOVWF 0x2E
L0047:
; 244: Endif
L0045:
; 245: 
; 246: Gosub show4
	CALL L0011
; 247: k41:
L0009:
; 248: If PORTC.0 = 0 Then Goto kk
	BTFSC 0x07,0
	GOTO L0048
	GOTO L0008
L0048:
; 249: If PORTC.1 = 0 Then Goto kk
	BTFSC 0x07,1
	GOTO L0049
	GOTO L0008
L0049:
; 250: 'continue rolling the time till user releases S1
; 251: INTCON.GIE = 1  'enable all un-masked interrupts
	BSF 0x0B,7
; 252: 
; 253: Return
	RETURN
; 254: show3:  'show hOUR digit on its display
L0010:
; 255: 	d3enable = 1  'False
	BSF 0x07,6
; 256: 	PORTB = mask3
	MOVF 0x32,W
	MOVWF 0x06
; 257: 
; 258: 	d3enable = 0  'True
	BCF 0x07,6
; 259: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 260: 	d3enable = 1  'False
	BSF 0x07,6
; 261: 	Return
	RETURN
; 262: show4:  'show high digit on its display
L0011:
; 263: 	d4enable = 1  'false
	BSF 0x07,7
; 264: 	PORTB = mask4
	MOVF 0x2E,W
	MOVWF 0x06
; 265: 	d4enable = 0  'True
	BCF 0x07,7
; 266: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 267: 	d4enable = 1  'False
	BSF 0x07,7
; 268: Return
	RETURN
; 269: getadresult:  'conversion routine
L0012:
; 270: High ad_action  'start the conversion
	BSF 0x1F,2
; 271: While ad_action  'wait until conversion is completed
L0050:
	BTFSS 0x1F,2
	GOTO L0051
; 272: Wend
	GOTO L0050
L0051:
; 273: tem = ADRES
	MOVF 0x1E,W
	MOVWF 0x3C
; 274: Return
	RETURN
; 275: tempshow:  'this subroutine is for temperature acquisition and display
L0013:
; 276: Gosub getadresult  'go to conversion routine
	CALL L0012
; 277: tt = tem / 10  'get temperature value high digits
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x3B
; 278: mask4 = 0xff
	MOVLW 0xFF
	MOVWF 0x2E
; 279: digit = tt
	MOVF 0x3B,W
	MOVWF 0x2C
; 280: mask3 = 0xff
	MOVLW 0xFF
	MOVWF 0x32
; 281: If digit > 19 Then
	MOVF 0x2C,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0052
; 282: digit = 2
	MOVLW 0x02
	MOVWF 0x2C
; 283: 
; 284: Gosub getmask
	CALL L0003
; 285: mask4 = mask
	MOVF 0x30,W
	MOVWF 0x2E
; 286: digit = tt - 2 * 10
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x3F
	oshonsoft_temp_1 EQU 0x3F
	MOVLW 0x02
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x3F
	MOVF R2H,W
	MOVWF 0x40
	MOVF 0x3F,W
	SUBWF 0x3B,W
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBLW 0x00
	MOVWF 0x40
	MOVF 0x3F,W
	MOVWF 0x2C
; 287: Gosub getmask
	CALL L0003
; 288: mask3 = mask
	MOVF 0x30,W
	MOVWF 0x32
; 289: Else
	GOTO L0053
L0052:
; 290: If digit > 9 Then
	MOVF 0x2C,W
	SUBLW 0x09
	BTFSC STATUS,C
	GOTO L0054
; 291: digit = 1
	MOVLW 0x01
	MOVWF 0x2C
; 292: Gosub getmask
	CALL L0003
; 293: mask4 = mask
	MOVF 0x30,W
	MOVWF 0x2E
; 294: digit = tt - 10
	MOVLW 0x0A
	SUBWF 0x3B,W
	MOVWF 0x2C
; 295: Gosub getmask
	CALL L0003
; 296: mask3 = mask
	MOVF 0x30,W
	MOVWF 0x32
; 297: Endif
L0054:
; 298: 
; 299: Endif
L0053:
; 300: 
; 301: Gosub getmask
	CALL L0003
; 302: mask3 = mask
	MOVF 0x30,W
	MOVWF 0x32
; 303: digit = tem Mod 10
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x2C
; 304: Gosub getmask
	CALL L0003
; 305: mask2 = mask
	MOVF 0x30,W
	MOVWF 0x36
; 306: rept: Gosub show4
L0014:
	CALL L0011
; 307: Gosub show3
	CALL L0010
; 308: mask1 = 0x8c
	MOVLW 0x8C
	MOVWF 0x35
; 309: Gosub show2
	CALL L0006
; 310: Gosub show1
	CALL L0005
; 311: If i < 35 Then Goto rept  'We show temp. display in every minute between 30-35 seconds
	MOVLW 0x23
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0055
	GOTO L0014
L0055:
; 312: Return
	RETURN
; 313: 
; End of program
L0056:	GOTO L0056
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x3A
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; End of listing
	END
